﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Catalogue
{
    public partial class Medicament : Form
    {

        public static string depotLegal;

        public Observation Observation = new Observation();  //Permet de pouvoir ouvrir après le form Observations
        public Medicament()
        {
            InitializeComponent();
        }

        private void Medicament_Load(object sender, EventArgs e)
        {
            lblFamille.Text = "";
            lblGroupe.Text = "";
            lblNomMedicament.Text = "";

            

            //Changement libelle
            lblFamille.Text = Accueil.famille;
            lblGroupe.Text = Accueil.groupe;
            lblNomMedicament.Text = FamilleMedicament.medicamentSelectionne;
            //Changement libelle
            

            string nomMedicament = FamilleMedicament.medicamentSelectionne;
            depotLegal = Métiers.Medicament.medicament(nomMedicament).Rows[0][3].ToString();


            //Affichage image du médicament
            picMedicament.Image = Image.FromFile("C:\\Users\\dorian balducci\\source\\repos\\Piscine\\img\\" + Métiers.Medicament.medicament(nomMedicament).Rows[0]["mDepotLegal"].ToString() + ".jpg");
            picMedicament.SizeMode = PictureBoxSizeMode.StretchImage;



            //Affichez le texte dans les richTextBox
            rtbComposition.Text = Métiers.Medicament.medicament(nomMedicament).Rows[0][0].ToString();
            rtbEffet.Text = Métiers.Medicament.medicament(nomMedicament).Rows[0][1].ToString();
            rtbConsigne.Text = Métiers.Medicament.medicament(nomMedicament).Rows[0][2].ToString();

            dgvObservation.DataSource = Métiers.Medicament.observations(FamilleMedicament.medicamentSelectionne);


            if (Accueil.etatBoutonOkRecherche==true) //si c'est un médicament sélectionné depuis la barre de recherche direct (si le bouton ok est appuyé)
            {
                lblGroupe.Text = Métiers.Medicament.groupeFamilleMedicament(Accueil.nomMedicament).Rows[0][0].ToString();
                lblFamille.Text = Métiers.Medicament.groupeFamilleMedicament(Accueil.nomMedicament).Rows[0][1].ToString();
                lblNomMedicament.Text = Accueil.nomMedicament;

                //Affichage image du médicament
                picMedicament.Image = Image.FromFile("C:\\Users\\dorian balducci\\source\\repos\\Piscine\\img\\" + Métiers.Medicament.medicament(Accueil.nomMedicament).Rows[0]["mDepotLegal"].ToString() + ".jpg");
                picMedicament.SizeMode = PictureBoxSizeMode.StretchImage;



                //Affichez le texte dans les richTextBox
                rtbComposition.Text = Métiers.Medicament.medicament(Accueil.nomMedicament).Rows[0][0].ToString();
                rtbEffet.Text = Métiers.Medicament.medicament(Accueil.nomMedicament).Rows[0][1].ToString();
                rtbConsigne.Text = Métiers.Medicament.medicament(Accueil.nomMedicament).Rows[0][2].ToString();

                dgvObservation.DataSource = Métiers.Medicament.observations(Accueil.nomMedicament);

                btnAccueil.Visible=false;
            }


            //Gestion de la largeur des colonnes
            dgvObservation.Columns[0].Width = 100; //Date   
            dgvObservation.Columns[1].Width = 180; //Observations
            dgvObservation.Columns[2].Width = 200; //Praticien
        }

        private void btnRetour_Click(object sender, EventArgs e)
        {
            Accueil.fermerAccueil = false;
            this.Close();
        }

        private void btnAccueil_Click(object sender, EventArgs e)
        {
            Accueil.fermerAccueil = true;
            this.Close();
        }

        private void btnAjouterRemarque_Click(object sender, EventArgs e)
        {
            Observation observation = new Observation();
            observation.Show(this);
        }

        private void Medicament_Activated(object sender, EventArgs e)
        {
            if (Accueil.fermerAccueil == true)
            {
                this.Close();
            }
        }
    }
}
